﻿Imports System.Text
Imports System.Runtime.InteropServices
Public Class GPIB_CONTEC

    '(0)Class variable
    Public MyAddress As Integer = 0                                                     'My address
    Private DeviceAddress As Integer = 0                                                'Device address
    Public MsgBuf As String = ""                                                        'Received Data
    Private gChCmd As GCHandle                                                          'GCHandle for Cmd array

    'Constructor
    Public Sub New()
        'Specify Pinned handle to Cmd
        If gChCmd.IsAllocated = False Then
            gChCmd = GCHandle.Alloc(Cmd, GCHandleType.Pinned)
        End If
        'Get address object by Pinned handle
        pCmd = gChCmd.AddrOfPinnedObject()
    End Sub

    '(1)Connect
    Public Function OpenInterface(ByVal PrimaryAddress As String) As Boolean
        Dim mode As Integer
        Dim eoi As Integer
        Dim delim As Integer
        Dim message As String = ""
        Dim ret As Integer

        ret = GpibInit(message)                                                         'Initialise GPIB
        If ret <> 0 Then
            MsgBox(message)
            Return False
        End If

        ret = GpBoardsts(&HAS, mode)                                                    'Read MASTER or SLAVE
        If ret <> 0 Then
            CheckRet("GpBoardsts", ret, message)                                        'Check return value
            MsgBox(message)
            Return False
        End If
        If mode <> 0 Then
            message = "This device is not MASTER. Please check your settings."
            MsgBox(message)
            Return False
        End If

        ret = GpBoardsts(&H8S, MyAddress)                                               'Get my address
        If mode <> 0 Then
            CheckRet("GpBoardsts", ret, message)                                        'Check return value
            MsgBox(message)
            Return False
        End If

        eoi = 1                                                                         '0:Not use / 1:Use
        delim = 3                                                                       '0:Unused / 1:CR+LF / 2:CR / 3:LF
        ret = GpDelim(delim, eoi)                                                       'Set delimiter code(EOI)
        If ret <> 0 Then
            CheckRet("GpDelim", ret, message)                                           'Check return value
            MsgBox(message)
            Return False
        End If

        ret = GpTimeout(10000)                                                          'Set timeout
        If ret <> 0 Then
            CheckRet("GpTimeout", ret, message)                                         'Check return value
            MsgBox(message)
            Return False
        End If

        DeviceAddress = CInt(PrimaryAddress)

        Return True
    End Function

    '(2)Disconnect
    Public Function CloseInterface() As Boolean
        GpibExit()                                                                      'End of GPIB connection

        CloseInterface = True
    End Function

    '(3)Send commands
    Public Function SendMsg(ByVal strMsg As String) As Boolean
        Dim ret As Boolean = False

        ret = GpibPrint(DeviceAddress, strMsg)                                          'Write data in the transmit buffer
        If ret <> 0 Then
            Return False
        End If

        Return True
    End Function

    '(4)Receive
    Public Function ReceiveMsg(ByVal timeout_ms As Long) As Boolean
        Dim message As String = ""
        Dim buf As New StringBuilder(8388608)
        Dim ret As Integer

        ret = GpTimeout(timeout_ms)                                                     'Set timeout
        If ret <> 0 Then
            CheckRet("GpTimeout", ret, Message)                                         'Check return value
            MsgBox(Message)
            Return False
        End If

        ret = GpibInputHioki(DeviceAddress, buf)                                        'Read data from the receive buffer
        If ret <> 0 Then
            MsgBuf = "Error"
            Return False
        End If
        MsgBuf = buf.ToString()                                                         'Save the data

        Return True

    End Function

    '(5)Transmit and receive commands
    Public Function SendQueryMsg(ByVal strMsg As String, ByVal timeout_ms As Long) As Boolean
        Dim buf As New StringBuilder(8388608)
        Dim ret As Boolean = False

        'GPIB.ReadString()                                                              'If exist the data in the receive buffer, read all data.

        ret = SendMsg(strMsg)                                                           'Transmit commands
        If ret Then
            If InStr(strMsg, "?") <> 0 Then
                ret = ReceiveMsg(timeout_ms)                                            'Receive response when command transmission is succeeded
            End If
        End If

        SendQueryMsg = ret
    End Function


End Class
